IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO]')
												 AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO]
GO
GO 
--EXEC P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO 22
CREATE PROCEDURE P_EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO (@CD_CTR INT=0)
WITH ENCRYPTION AS
SET NOCOUNT ON 

DECLARE @PART_ACUMULADA MONEY
DECLARE @CONTROLE INT
DECLARE @DEMANDA_TOTAL MONEY
DECLARE @CD_GRUPO_CURVA INT
DECLARE @CD_SIGLA INT
DECLARE @CD_CTR_CONTROLE INT
DECLARE @CD_GRUPO_LOJAS INT
DECLARE @TP_NIVEL INT

CREATE TABLE #RsProdProcParetoInicial (CD_EMP INT,
									   CD_PROD INT,
									   QTDE_DEMANDATOTAL MONEY,
								       MEDIA_DEMANDA_GRUPO MONEY,
								       CD_CTR INT,
								       QTDE_FILIAIS INT,
									   CD_GRUPO_CURVA INT,
									   DS_TIPO_NIVEL VARCHAR(200),
								       PART_ACUMULADA MONEY,
								       PERC_PART_ACUMULADA MONEY,
								       CD_SIGLA INT,
								       DS_SIGLA VARCHAR(2),
									   FLAG_NAO_REVISAR_PARETO_AUTO INT,
									   VLR_PARAMETRO_ATUAL MONEY,
									   TP_NIVEL INT)

CREATE TABLE #RsProdProcParetoFinal (CONTROLE INT IDENTITY(1, 1),
								CD_EMP INT,
							    CD_PROD INT,
								QTDE_DEMANDATOTAL MONEY,
								MEDIA_DEMANDA_GRUPO MONEY,
								CD_CTR INT,
								QTDE_FILIAIS INT,
								CD_GRUPO_CURVA INT,
								DS_TIPO_NIVEL VARCHAR(200),
								PART_ACUMULADA MONEY,
								PERC_PART_ACUMULADA MONEY,
								CD_SIGLA INT,
								DS_SIGLA VARCHAR(2),
								FLAG_NAO_REVISAR_PARETO_AUTO INT,
								VLR_PARAMETRO_ATUAL MONEY,
								TP_NIVEL INT)

INSERT INTO #RsProdProcParetoInicial
SELECT
	EST_PROD_CPL.CD_EMP,
	EST_PROD_CPL.CD_PROD,
	SUM(EST_PROD_CPL.MEDIAF) AS DEMANDATOTAL,
	SUM(EST_PROD_CPL.MEDIAF) / COUNT(EST_PROD_CPL.CD_FILIAL) AS MEDIAVENDAS,
	EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_CTR,
	COUNT(EST_PROD_CPL.CD_FILIAL) AS QTDE_FILIAIS,
	0 AS CD_GRUPO_CURVA,
	'' AS DS_TIPO_NIVEL,
	0 AS PART_ACUMULADA,
	0 AS PERC_PART_ACUMULADA,
	0 AS CD_SIGLA,
	'',
	0 AS FLAG_NAO_REVISAR_PARETO_AUTO,
	0 AS VLR_PARAMETRO_ATUAL,
	0
FROM
	EST_PROD_CPL INNER JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL ON
	EST_PROD_CPL.CD_EMP = EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_EMP AND
	EST_PROD_CPL.CD_FILIAL = EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_FILIAL  	
WHERE
	EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_CTR=@CD_CTR
GROUP BY
	 EST_PROD_CPL.CD_EMP,
	 EST_PROD_CPL.CD_PROD,
	 EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL.CD_CTR
HAVING
	SUM(EST_PROD_CPL.MEDIAF) > 0

UPDATE
	prod
SET
	prod.CD_GRUPO_CURVA = ISNULL(B.CD_GRUPO_CURVA,-1),
	prod.DS_TIPO_NIVEL=ISNULL(B.DS_GRUPO_PARAMETRO,'GRUPO DE CURVA NAO DEFINIDO'),
	prod.FLAG_NAO_REVISAR_PARETO_AUTO = ISNULL(B.FLAG_NAO_REVISAR_PARETO_AUTO,0),
	prod.VLR_PARAMETRO_ATUAL=ISNULL(B.VLR_PARAMETRO_ATUAL,0),
	prod.TP_NIVEL = B.TP_NIVEL
FROM
	#RsProdProcParetoInicial prod 
	OUTER APPLY UFD_EST_PARAM_COMPRAS_GRUPO_CURVA (prod.CD_EMP,prod.CD_CTR,prod.CD_PROD,0) B

DECLARE CalcPartAcumuladaGrupoCurva CURSOR FAST_FORWARD FOR
										SELECT
											DISTINCT CD_GRUPO_CURVA,
											CD_CTR,
											TP_NIVEL	
										FROM
											#RsProdProcParetoInicial;
OPEN CalcPartAcumuladaGrupoCurva;

FETCH NEXT FROM CalcPartAcumuladaGrupoCurva INTO
									@CD_GRUPO_CURVA,
									@CD_GRUPO_LOJAS,
									@TP_NIVEL;

WHILE @@FETCH_STATUS = 0
	BEGIN
	
	INSERT INTO #RsProdProcParetoFinal
									(CD_EMP,
									CD_PROD,
									QTDE_DEMANDATOTAL,
									MEDIA_DEMANDA_GRUPO,
									CD_CTR,
									QTDE_FILIAIS,
									CD_GRUPO_CURVA,
									DS_TIPO_NIVEL,
									PART_ACUMULADA,
									PERC_PART_ACUMULADA,
									CD_SIGLA,
									DS_SIGLA,
									FLAG_NAO_REVISAR_PARETO_AUTO,
									VLR_PARAMETRO_ATUAL,
									TP_NIVEL)
	
	SELECT
		CD_EMP,
		CD_PROD,
		QTDE_DEMANDATOTAL,
		MEDIA_DEMANDA_GRUPO,
		CD_CTR,
		QTDE_FILIAIS,
		CD_GRUPO_CURVA,
		DS_TIPO_NIVEL,
		PART_ACUMULADA,
		PERC_PART_ACUMULADA,
		CD_SIGLA,
		DS_SIGLA,
		FLAG_NAO_REVISAR_PARETO_AUTO,
		VLR_PARAMETRO_ATUAL,
		TP_NIVEL
	FROM
		#RsProdProcParetoInicial
	WHERE
		CD_GRUPO_CURVA=@CD_GRUPO_CURVA
		AND CD_CTR = @CD_GRUPO_LOJAS
		AND TP_NIVEL = @TP_NIVEL
	ORDER BY
		MEDIA_DEMANDA_GRUPO DESC
			
	SET @DEMANDA_TOTAL = ISNULL((SELECT
									SUM(MEDIA_DEMANDA_GRUPO)
								FROM
									#RsProdProcParetoFinal
								WHERE
									CD_GRUPO_CURVA = @CD_GRUPO_CURVA
									AND CD_CTR = @CD_GRUPO_LOJAS
									AND TP_NIVEL = @TP_NIVEL),0)		
	SET @PART_ACUMULADA=0
	DECLARE CalcPartAcumulada CURSOR FAST_FORWARD
	FOR SELECT
			CONTROLE
		FROM
			#RsProdProcParetoFinal
		ORDER BY
				CONTROLE;

	OPEN CalcPartAcumulada;
	FETCH NEXT FROM CalcPartAcumulada INTO
										@CONTROLE;
	WHILE @@FETCH_STATUS = 0
		BEGIN
			UPDATE 
				#RsProdProcParetoFinal
			SET
				@PART_ACUMULADA = @PART_ACUMULADA + MEDIA_DEMANDA_GRUPO,
				PART_ACUMULADA=@PART_ACUMULADA,
				PERC_PART_ACUMULADA=(@PART_ACUMULADA / @DEMANDA_TOTAL) * 100,
				@CD_SIGLA = ISNULL((SELECT 
										TOP 1 CD_SIGLA
									FROM
										EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA
									WHERE
										PERC_PARETO_ACUMULADO=
									(SELECT
										MIN(PERC_PARETO_ACUMULADO) 
									FROM
										EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA
									WHERE
										CD_GRUPO_CURVA=@CD_GRUPO_CURVA
										AND PERC_PARETO_ACUMULADO >=((@PART_ACUMULADA / @DEMANDA_TOTAL) * 100))),0),
				CD_SIGLA=@CD_SIGLA,
				DS_SIGLA = CASE WHEN @CD_SIGLA=5 THEN
								'AA'
						   WHEN @CD_SIGLA=1 THEN
								'A'
						   WHEN @CD_SIGLA=2 THEN
								'B'
						   WHEN @CD_SIGLA=3 THEN
								'C'
						   WHEN @CD_SIGLA=4 THEN
								'D'
						  ELSE
						   ''
						  END
			WHERE	
				CONTROLE = @CONTROLE;

	--Proximo registro
	FETCH NEXT FROM CalcPartAcumulada INTO
										@CONTROLE;
	END;

	--Fechando cursor
	CLOSE CalcPartAcumulada;
	--Desalocando cursor da memoria
	DEALLOCATE CalcPartAcumulada

	--Gravando analise de pareto para auditoria
	INSERT INTO EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_PROC
	(DT_CAD,
	DT_CAD_PROC,
	CD_CTR_PARAM_COMPRAS_GRUPO)
	SELECT
		DISTINCT CONVERT(CHAR(10),GETDATE(),112),
		GETDATE(),
		P.CD_CTR
	FROM
		#RsProdProcParetoFinal P

	SET @CD_CTR_CONTROLE = SCOPE_IDENTITY()

	INSERT INTO EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_PROC_CPL
	(CD_CTR,
	CD_CONTROLE_PARETO,
	CD_EMP,
	CD_PROD,
	QTDE_DEMANDATOTAL,
	MEDIA_DEMANDA_GRUPO,
	QTDE_FILIAIS_PARAM_COMPRAS_GRUPO,
	CD_GRUPO_CURVA,
	DS_TIPO_NIVEL,
	PART_ACUMULADA,
	PERC_PART_ACUMULADA,
	CD_SIGLA,
	DS_SIGLA,
	FLAG_NAO_REVISAR_PARETO_AUTO,
	VLR_PARAMETRO_PARETO_RECALC,
	TP_NIVEL)
	SELECT
		@CD_CTR_CONTROLE,
		P.CONTROLE,
		P.CD_EMP,
		P.CD_PROD,
		P.QTDE_DEMANDATOTAL,
		P.MEDIA_DEMANDA_GRUPO,
		P.QTDE_FILIAIS,
		P.CD_GRUPO_CURVA,
		P.DS_TIPO_NIVEL,
		P.PART_ACUMULADA,
		P.PERC_PART_ACUMULADA,
		P.CD_SIGLA,
		P.DS_SIGLA,
		P.FLAG_NAO_REVISAR_PARETO_AUTO,
		P.VLR_PARAMETRO_ATUAL,
		P.TP_NIVEL
	FROM
		#RsProdProcParetoFinal P 

	UPDATE
		P
	SET 
		P.FLAG_NAO_REVISAR_PARETO_AUTO=ISNULL(EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA.FLAG_NAO_REVISAR_PARETO_AUTO,0),
		P.VLR_PARAMETRO_ATUAL=ISNULL(EST_PARAM_COMPRAS_GRUPO_CURVA_USO.VLR_PARAMETRO,0)
	FROM
		#RsProdProcParetoFinal P LEFT OUTER JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_USO ON
		P.CD_CTR = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_CTR_COMPRAS_GRUPO AND
		P.CD_GRUPO_CURVA = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_GRUPO_CURVA AND
		P.CD_SIGLA = EST_PARAM_COMPRAS_GRUPO_CURVA_USO.CD_SIGLA
		INNER JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA ON
		P.CD_GRUPO_CURVA = EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA.CD_GRUPO_CURVA AND
		P.CD_SIGLA = EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA.CD_SIGLA

	--Data de revisao
	DELETE FROM EST_PARAM_COMPRAS_GRUPO_CURVA_USO WHERE CD_CTR_COMPRAS_GRUPO=@CD_GRUPO_LOJAS AND CD_GRUPO_CURVA = @CD_GRUPO_CURVA AND TP_NIVEL = @TP_NIVEL

	INSERT INTO EST_PARAM_COMPRAS_GRUPO_CURVA_USO
	(CD_CTR_COMPRAS_GRUPO,
	CD_GRUPO_CURVA,
	CD_SIGLA,
	VLR_PARAMETRO,
	CD_CTR_PROC,
	DT_CAD,
	VLR_PARAMETRO_PARETO_RECALC,
	FLAG_NAO_REVISAR_PARETO_AUTO,
	TP_NIVEL)
	SELECT
		CD_CTR,
		CD_GRUPO_CURVA,
		CD_SIGLA,
		CASE WHEN FLAG_NAO_REVISAR_PARETO_AUTO=0 THEN
			CASE WHEN CD_SIGLA = 4 THEN 
				0 
			ELSE 
				ROUND(MIN(MEDIA_DEMANDA_GRUPO),3) 
			END 
		ELSE
			VLR_PARAMETRO_ATUAL
		END AS VLR_PARAMETRO_NOVO,
		@CD_CTR_CONTROLE,
		GETDATE(),
		CASE WHEN CD_SIGLA = 4 THEN 
			0 
		ELSE 
			ROUND(MIN(MEDIA_DEMANDA_GRUPO),3) 
		END AS VLR_PARAMETRO,
		FLAG_NAO_REVISAR_PARETO_AUTO,
		TP_NIVEL
	FROM
		#RsProdProcParetoFinal
	WHERE
		CD_SIGLA > 0 
		AND CD_GRUPO_CURVA = @CD_GRUPO_CURVA
		AND CD_CTR = @CD_GRUPO_LOJAS
	GROUP BY
		CD_SIGLA,
		CD_CTR,
		CD_GRUPO_CURVA,
		FLAG_NAO_REVISAR_PARETO_AUTO,
		VLR_PARAMETRO_ATUAL,
		TP_NIVEL
		
	DELETE FROM EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_PROC_ULTIMO WHERE CD_CTR_COMPRAS_GRUPO=@CD_GRUPO_LOJAS AND CD_GRUPO_CURVA = @CD_GRUPO_CURVA AND TP_NIVEL = @TP_NIVEL

	INSERT INTO EST_PARAM_COMPRAS_GRUPO_CURVA_PARETO_PROC_ULTIMO
		(CD_CTR_COMPRAS_GRUPO,
		CD_GRUPO_CURVA,
		DT_ULTIMA_REVISAO_PARETO,
		TP_NIVEL)
	SELECT
		DISTINCT CD_CTR,
		CD_GRUPO_CURVA,
		CONVERT(CHAR(10),GETDATE(),112),
		TP_NIVEL
	FROM
		#RsProdProcParetoFinal
	WHERE
		CD_SIGLA > 0 
		AND CD_GRUPO_CURVA = @CD_GRUPO_CURVA
		AND CD_CTR = @CD_GRUPO_LOJAS
		AND TP_NIVEL=@TP_NIVEL
	
	TRUNCATE TABLE #RsProdProcParetoFinal;

FETCH NEXT FROM CalcPartAcumuladaGrupoCurva INTO
									@CD_GRUPO_CURVA,
									@CD_GRUPO_LOJAS,
									@TP_NIVEL;
END
--Fechando cursor
CLOSE CalcPartAcumuladaGrupoCurva;
--Desalocando cursor da memoria
DEALLOCATE CalcPartAcumuladaGrupoCurva

DROP TABLE #RsProdProcParetoInicial;
DROP TABLE #RsProdProcParetoFinal;